import Link from "next/link";

export default function Home() {
  return (
    <main className="p-10">
      <h1 className="text-4xl font-bold mb-6">SponsorKits</h1>
      <p className="mb-6 text-lg">
        Get custom sportswear for your team at a lower price by partnering with
        local sponsors.
      </p>

      <div className="space-y-4">
        <Link
          href="/teams/new-order"
          className="px-6 py-3 bg-blue-600 text-white rounded-lg shadow hover:bg-blue-700"
        >
          Create New Team Order
        </Link>

        <div>
          <h2 className="text-2xl font-semibold mt-10 mb-3">How it works:</h2>
          <ol className="list-decimal list-inside space-y-2">
            <li>Create your team’s jersey order</li>
            <li>Select a sponsor to lower the cost</li>
            <li>Upload your team logo</li>
            <li>Checkout securely with Stripe</li>
          </ol>
        </div>
      </div>
    </main>
  );
}